<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Services;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Migrations\CreateContentTypes;

class InitializeServicesNfh2 extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $bridge = new BridgeContent();

        Services::get()->each(fn ($service) => $bridge->contentDelete('services', $service->uuid));

        $this->bootUp(__FILE__);
        $this->migrateContent('services');
        $this->finishUp();

        collect([
            "ALP" => "Alpes",
            "ALS" => "Alsace",
            "AQU" => "Aquitaine",
            "AUV" => "Auvergne",
            "BAS" => "Basse-Normandie",
            "BGN" => "Bourgogne",
            "BRE" => "Bretagne",
            "CEN" => "Centre",
            "CHA" => "Champagne-Ardenne",
            "COR" => "Corse",
            "FRA" => "Franche-Comté",
            "DGY" => "Guyane",
            "HAU" => "Haute-Normandie",
            "IDF" => "Ile de France",
            "LAN" => "Languedoc-Roussillon",
            "LIM" => "Limousin",
            "LOR" => "Lorraine",
            "DMA" => "Martinique",
            "MID" => "Midi-Pyrénées",
            "NOR" => "Nord-pas-de-Calais",
            "OCI" => "Océan Indien",
            "PAY" => "Pays de la Loire",
            "PIC" => "Picardie",
            "POI" => "Poitou-Charentes",
            "PRO" => "Provence-Alpes-Côte-d'Azur",
            "RHO" => "Rhône",
            "Affaires Financières" => "Affaires financières",
            "AMG" => "AMG (Achats et Moyens Généraux)",
            "Contrôle Interne" => "Contrôle interne",
            "Communication" => "Communication",
            "DFC" => "DFC (Développement de la Formation et des Compétences)",
            "Direction" => "Direction générale",
            "Instances Nationales" => "Instances",
            "Ressources Humaines" => "GRH (Gestion des Ressources Humaines)",
            "Informatique" => "SI (Systèmes d'Information)",
        ])->each(fn (string $title, string $code) => $bridge->contentInsert('services', [
            'title' => $title,
            'code' => (string) str($code)->ascii()->lower()->snake(),
        ]));
    }
}
