<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Tools;
use Inside\Content\Models\Contents\Users;
use Inside\Host\Bridge\BridgeContent;

class UpdateUsersDefaultTools extends Migration
{
    public function up(): void
    {
        $defaultTools = collect([
            "Plateforme achat",
            "Horoquartz",
            "Recrutement",
            "Lyreco",
            "Action logement",
            "Alfresco",
        ]);

        $toolsUuids = Tools::query()
            ->whereIn('title', $defaultTools)
            ->get()
            ->sortBy(fn (Tools $tool) => $defaultTools->search($tool->title))
            ->pluck('uuid');

        $bridge = new BridgeContent();
        Users::each(function (Users $user) use ($toolsUuids, $bridge) {
            $tools = $user->tools->pluck('uuid')->concat($toolsUuids)->unique()->all();
            $bridge->contentUpdate('users', [
                'uuid' => $user->uuid,
                'tools' => $tools,
            ]);
        });
    }
}
