<?php

use Illuminate\Support\Str;
use Inside\Content\Models\Contents\Services;

function isSupportAccount(string $samaccountname): bool
{
    return in_array($samaccountname, [
        'b.vautrin',
        'p.ribault',
        'e.ghalaza',
        'f.mallet',
        't.dantigny',
    ]);
}

return [
    'postfilter' => function ($users) {
        $services = Services::get()->pluck('title', 'code');

        return $users->reject(fn ($user) => match (true) {
            isSupportAccount($user->samaccountname[0]) => false,
            empty($user->department[0]) => true,
            str($user->department[0])->contains('Hors Groupe') => true,
            default => false,
        })->map(function ($user) use ($services) {
            $user['services'] = [];

            if (isSupportAccount($user->samaccountname[0])) {
                $user->maintenance = [true];

                return $user;
            }

            $service = (string) str($user->distinguishedname[0])->after('OU=')->before(',OU=')->ascii()->lower()->snake();

            if ($services->has($service)) {
                $user['services'] = [$services->get($service)];
            }

            $user->maintenance = [false];

            return $user;
        });
    },
];
