import { ROUTE_NAMES } from '@inside-news/constants'

import locationsCategoryMixin from './locations-category-mixin'

export default {
  mixins: [locationsCategoryMixin],
  computed: {
    m_newsCategoriesConfigs() {
      return {
        news_categories: {
          data: news => news.news_categories?.data,
          href: newsCategory => ({
            name: ROUTE_NAMES.listing,
            query: { news_categories: newsCategory.uuid }
          }),
          disabledOn: [ROUTE_NAMES.listing]
        },
        ...this.m_getLocationCategoryConfig(ROUTE_NAMES.listing)
      }
    }
  }
}
