export default {
  data: () => ({
    m_locationsFields: [
      {
        locations: {
          fields: ['uuid', 'title', 'content_type'],
          filters: { 'status:eq': 1, sort: 'title:asc' }
        }
      }
    ]
  }),
  methods: {
    m_getLocationCategoryConfig(listingRouteName) {
      return {
        locations: {
          data: news =>
            news.locations?.data.map(location => ({
              ...location,
              color: this.$_theme('colorTextLight')
            })),
          href: location => ({
            name: listingRouteName,
            query: { locations: location.uuid }
          }),
          disabledOn: [listingRouteName]
        }
      }
    }
  }
}
