import { withFetch } from 'inside-collection/hocs'

import SpacePage from '../pages/spaces/SpacePage'
import SpaceTabsListingPage from '../pages/spaces/SpaceTabsListingPage'
import { fetchSpace, fetchSpaceTabsListing } from '../fetch/spaces'

import AdminAdvancedSettingsHomePage from '../pages/advanced-settings/AdminAdvancedSettingsHomePage'
import { fetchSettings } from '@inside-administration/fetch'

export default [
  {
    name: 'HomePage',
    meta: { disabled: false },
    component: () => import('../pages/HomePage')
  },
  {
    name: 'NewsListingPage',
    meta: { disabled: false },
    component: () => import('../pages/news/NewsListingPage')
  },
  {
    name: 'NewsPage',
    meta: { disabled: false },
    component: () => import('../pages/news/NewsPage')
  },
  {
    name: 'EventsCalendarPage',
    meta: { disabled: false }
  },
  {
    name: 'EventPage',
    meta: { disabled: false }
  },
  {
    name: 'SimplePage',
    meta: { disabled: false }
  },
  {
    name: 'GedPage',
    meta: { disabled: false },
    props: {
      cardOverlayEnabled: false
    }
  },
  {
    name: 'ToolsPage',
    meta: { disabled: false },
    props: {
      requestFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      },
      toolsFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      }
    }
  },
  {
    name: 'SpacePage',
    path: {
      fr: '/espaces/:slug',
      en: '/spaces/:slug',
      es: '/espacio/:slug',
      de: '/platz/:slug',
      pt: '/espaco/:slug'
    },
    alias: '/spaces/:slug',
    component: withFetch(SpacePage)(fetchSpace),
    meta: { content: 'spaces' }
  },
  {
    name: 'SpaceTabsListingPage',
    path: {
      fr: '/espaces/pages/:slug',
      en: '/spaces/pages/:slug',
      es: '/espacio/paginas/:slug',
      de: '/platz/seiten/:slug',
      pt: '/espaco/paginas/:slug'
    },
    alias: [
      '/fr/espaces/:slug/pages',
      '/en/spaces/:slug/pages',
      '/es/espacio/:slug/paginas',
      '/de/platz/:slug/seiten',
      '/pt/espaco/:slug/paginas'
    ],
    component: withFetch(SpaceTabsListingPage)(fetchSpaceTabsListing),
    meta: { content: 'spaces' }
  },
  {
    name: 'JTNewsListingPage',
    path: {
      fr: '/jt-nickel',
      en: '/jt-nickel',
      de: '/jt-nickel',
      es: '/jt-nickel',
      pt: '/jt-nickel'
    },
    component: () => import('../pages/jt_news/JTNewsListingPage'),
    meta: { customSlug: 'jt_news' }
  },
  {
    name: 'JTNewsPage',
    path: {
      fr: '/jt-nickel/:slug',
      en: '/jt-nickel/:slug',
      de: '/jt-nickel/:slug',
      es: '/jt-nickel/:slug',
      pt: '/jt-nickel/:slug'
    },
    component: () => import('../pages/jt_news/JTNewsPage'),
    meta: { content: 'jt_news' }
  },
  {
    name: 'WeeklyNewsListingPage',
    path: {
      fr: '/hebdos',
      en: '/weeklies',
      de: '/wochentlich',
      es: '/semanarios',
      pt: '/newsletter'
    },
    component: () => import('../pages/weekly_news/WeeklyNewsListingPage'),
    meta: { customSlug: 'weekly_news' }
  },
  {
    name: 'WeeklyNewsPage',
    path: {
      fr: '/hebdos/:slug',
      en: '/weeklies/:slug',
      de: '/wochentlich/:slug',
      es: '/semanarios/:slug',
      pt: '/newsletter/:slug'
    },
    component: () => import('../pages/weekly_news/WeeklyNewsPage'),
    meta: { content: 'weekly_news' }
  },
  {
    name: 'OffersListingPage',
    path: {
      fr: '/petites-annonces',
      en: '/offers',
      de: '/bietet-an',
      es: '/ofertas',
      pt: '/ofertas'
    },
    component: () => import('../pages/OffersListingPage'),
    meta: { customSlug: 'offers' }
  },
  {
    name: 'AdminAdvancedSettingsHomePage',
    component: withFetch(AdminAdvancedSettingsHomePage, { size: 'xxl' })(
      fetchSettings
    ),
    meta: { admin: true, display: true }
  }
]
