import { http } from '@inside-library/helpers/Http'

export default {
  spaces: {
    add: ({ data }) => ({
      name: 'SpacePage',
      params: { slug: data.slug[0] }
    })
  },
  spacesTabs: {
    add: async ({ data }) => {
      const { data: tabs } = await http.get('content/spaces_tabs', {
        fields: [
          'uuid',
          'slug',
          {
            spaces: {
              fields: ['slug']
            }
          }
        ],
        filters: {
          'status:eq': 1,
          'uuid:eq': data.uuid
        }
      })

      return {
        name: 'SpaceTabsListingPage',
        params: {
          slug: tabs[0]?.spaces?.slug?.[0]
        }
      }
    },
    delete: async ({ uuid }) => {
      const { data: tabs } = await http.get('content/spaces_tabs', {
        fields: [
          'uuid',
          {
            spaces: {
              fields: ['slug']
            }
          }
        ],
        filters: {
          'status:eq': 1,
          'uuid:eq': uuid
        }
      })

      return {
        name: 'SpaceTabsListingPage',
        params: {
          slug: tabs[0]?.spaces?.slug?.[0]
        }
      }
    },
    globalSearch: async ({ data }) => {
      const { data: tabs } = await http.get('content/spaces_tabs', {
        fields: ['uuid', { spaces: ['uuid', 'title', 'slug'] }],
        filters: { 'status:eq': 1, 'uuid:eq': data.uuid }
      })

      return {
        route: {
          name: 'SpaceTabsListingPage',
          params: {
            slug: tabs[0]?.spaces?.slug?.[0]
          }
        }
      }
    }
  },
  spacesPages: {
    add: async ({ data }) => {
      const { data: spacesPages } = await http.get('content/spaces_pages', {
        fields: [
          'uuid',
          'slug',
          {
            spaces_tabs: [
              'uuid',
              'title',
              {
                spaces: {
                  fields: ['slug']
                }
              }
            ]
          }
        ],
        filters: {
          'status:eq': 1,
          'uuid:eq': data.uuid
        }
      })

      return {
        name: 'SpaceTabsListingPage',
        params: {
          slug: spacesPages?.[0].spaces_tabs?.spaces?.slug?.[0]
        },
        query: { page: data.uuid }
      }
    },
    delete: async ({ uuid }) => {
      const { data: spacesPages } = await http.get('content/spaces_pages', {
        fields: [
          'uuid',
          'title',
          {
            spaces_tabs: [
              {
                spaces: {
                  fields: ['slug']
                }
              }
            ]
          }
        ],
        filters: {
          'status:eq': 1,
          'uuid:eq': uuid
        }
      })

      return {
        name: 'SpaceTabsListingPage',
        params: {
          slug: spacesPages?.[0].spaces_tabs?.spaces?.slug?.[0]
        }
      }
    },
    globalSearch: async ({ data }) => {
      const { data: spacesPages } = await http.get('content/spaces_pages', {
        fields: [
          'uuid',
          'title',
          {
            spaces_tabs: [
              'uuid',
              'title',
              {
                spaces: {
                  fields: ['uuid', 'title', 'slug']
                }
              }
            ]
          }
        ],
        filters: { 'uuid:eq': data.uuid }
      })

      return {
        route: {
          name: 'SpaceTabsListingPage',
          params: {
            slug: spacesPages?.[0].spaces_tabs?.spaces?.slug?.[0]
          },
          query: { page: data.uuid }
        }
      }
    }
  },
  jtNews: {
    add: ({ data }) => ({
      name: 'JTNewsPage',
      params: { slug: data.slug[0] }
    }),
    delete: () => ({ name: 'JTNewsListingPage' }),
    fallback: ({ data }) => `/${data.slug[0]}`
  },
  weeklyNews: {
    add: ({ data }) => ({
      name: 'WeeklyNewsPage',
      params: { slug: data.slug[0] }
    }),
    delete: () => ({ name: 'WeeklyNewsListingPage' }),
    fallback: ({ data }) => `/${data.slug[0]}`
  },
  offers: {
    add: () => ({ name: 'OffersListingPage' }),
    delete: () => ({ name: 'OffersListingPage' })
  },
  offersCategories: {
    add: () => ({ name: 'OffersListingPage' }),
    delete: () => ({ name: 'OffersListingPage' })
  }
}
