import { markRaw } from 'vue'

import DateUi from '@inside-ui/DateUi'

export default {
  components: { DateUi },
  methods: {
    m_scaffoldOffersHeader(fields) {
      const categories = this.m_scaffoldOffersCategories(fields)

      return [
        {
          id: 'date',
          class: 'date',
          tag: markRaw(DateUi),
          data: { date: fields.published_at }
        },
        {
          id: 'categories',
          class: 'categories ml-s',
          children: categories,
          hideIf: () => !categories.length || this.getMobile
        }
      ]
    },
    m_scaffoldOffersCategories(fields) {
      return fields.offers_categories.data.map(category => ({
        class: ['tag', 'mr-xs', { 'px-xs': !!category.color }],
        value: category.title,
        data: {
          style: {
            backgroundColor: category.color,
            color: category.color
              ? this.$_theme('colorLight')
              : this.$_theme('colorPrimary')
          }
        }
      }))
    }
  }
}
