<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddContactsToOffers extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            type: 'offers',
            fieldName: 'contact',
            options:  [
                'name' => 'contact',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => true,
                'weight' => 4,
                'title' => [
                    'fr' => 'Email de contact',
                    'en' => 'Contact email',
                    'es' => 'Correo de contacto',
                    'de' => 'Kontakt E-Mail',
                    'pt' => 'E-mail de contato',
                    'nl' => 'Contact e-mail',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => 4,
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            weight: 4
        );
    }
}
