<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Custom;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Migrations\CreateContentTypes;

class AddMovementsCustomPage extends Migration
{
    use CreateContentTypes;

    private function createMovementsCustomPage(BridgeContent $bridge, string $langcode, ?string $uuidHost = null): ?string
    {
        $titles = [
            'fr' => 'MOUVEMENTS',
            'en' => 'MOVEMENTS',
            'es' => 'MOVIMIENTOS',
            'de' => 'BEWEGUNGEN',
            'pt' => 'MOVIMENTOS',
        ];

        if (empty($titles[$langcode])) {
            return null;
        }

        $fields = [
            'custom_slug' => 'newcomers',
            'redirection_page' => 'NewcomersListingPage',
            'title' => $titles[$langcode],
            'langcode' => $langcode,
        ];

        if ($uuidHost) {
            $fields['uuid_host'] = $uuidHost;
        }

        $uuid = Custom::query()
            ->where('custom_slug', $fields['custom_slug'])
            ->where('langcode', $langcode)
            ->first()
            ?->uuid;

        if ($uuid) {
            $fields['uuid'] = $uuid;
        }

        return $bridge->contentInsert('custom', $fields, $uuid === null);
    }

    public function up(): void
    {
        $locale = config('app.locale');
        $langs = list_languages();
        $bridge = new BridgeContent();

        $originalUuid = $this->createMovementsCustomPage($bridge, $locale);
        $original = Custom::find($originalUuid);

        if ($original === null) {
            throw new Exception("Could not create original movements custom page (locale: $locale)");
        }


        foreach ($langs as $lang) {
            if ($lang !== $locale) {
                $this->createMovementsCustomPage($bridge, $lang, $original->uuid_host);
            }
        }
    }
}
