<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Tools;
use Inside\Content\Models\Contents\Users;
use Inside\Host\Bridge\BridgeContent;

class SetDefaultUsersTools extends Migration
{
    public function up(): void
    {
        $defaultToolsTitles = [
            'Helpdesk',
            'Nickel People',
            'Gmail',
            'Poser mes congés',
            'Boîte idées'
        ];

        $bridge = new BridgeContent();
        $defaultTools = Tools::query()->whereIn('title', $defaultToolsTitles)
            ->get()
            ->sortBy(fn (Tools $tool) => array_search($tool->title, $defaultToolsTitles));

        if ($defaultTools->isEmpty()) {
            throw new Exception('Default tools not created yet !');
        }

        $users = Users::all();
        foreach ($users as $user) {
            $tools = $defaultTools->where('langcode', $user->langcode)->pluck('uuid');
            $userTools = $user->tools->pluck('uuid')->reject(fn (string $uuid) => $tools->contains($uuid));

            $bridge->contentUpdate('users', [
                'uuid' => $user->uuid,
                'tools' => $tools->concat($userTools)->all(),
            ]);
        }
    }
}
