<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'users',
        'translatable' => false,
        'searchable' => false,
        'global_searchable' => false,
        'aliasable' => false,
        'permissible' => false,
        'categorizable' => false,
        'listing_type' => 'hidden',
        'title' => [
            'fr' => 'Utilisateur',
            'en' => 'User',
            'es' => 'Usuario',
            'de' => 'Benutzer',
            'pt' => 'Utilizador',
        ],
    ],
    'fields' => [
        [
            'name' => 'locations',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => true,
            'required' => false,
            'weight' => 6,
            'title' => [
                'fr' => 'Site',
                'en' => 'Location',
                'es' => 'Ubicación',
                'de' => 'Standort',
                'pt' => 'Localização',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 6,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['locations'],
                'cardinality' => -1,
            ],
        ],
        [
            'name' => 'tools',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 7,
            'title' => [
                'fr' => 'Accès rapides',
                'en' => 'Quick access',
                'es' => 'Acceso rapido',
                'de' => 'Schneller Zugang',
                'pt' => 'Acesso rápido',
            ],
            'widget' => [
                'type' => BridgeContentType::OPTIONS_BUTTONS_WIDGET,
                'settings' => [],
                'weight' => 7,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['tools'],
                'cardinality' => -1,
            ],
        ],
    ],
];
