<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'spaces',
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => false,
        'aliasable' => true,
        'permissible' => true,
        'categorizable' => true,
        'listing_type' => 'content',
        'title' => [
            'fr' => 'Espace',
            'en' => 'Space',
            'es' => 'Espacio',
            'de' => 'Platz',
            'pt' => 'Espaço',
        ],
    ],
    'fields' => [
        [
            'name' => 'banner',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 0,
            'title' => [
                'fr' => 'Bannière',
                'en' => 'Banner',
                'es' => 'Bandera',
                'de' => 'Banner',
                'pt' => 'Banner',
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => 0,
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'introduction',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Introduction',
                'en' => 'Introduction',
                'es' => 'Introducción',
                'de' => 'Einführung',
                'pt' => 'Introdução',
            ],
            'widget' => [
                'type' => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [
                    'rows' => 5,
                    'placeholder' => '',
                ],
                'weight' => 1,
            ],
            'type' => BridgeContentType::TEXTAREA_FIELD,
            'settings' => [
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'presentation',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 2,
            'title' => [
                'fr' => 'Présentation',
                'en' => 'Presentation',
                'es' => 'Presentación',
                'de' => 'Präsentation',
                'pt' => 'Apresentação',
            ],
            'widget' => [
                'type' => BridgeContentType::WYSIWYG_WIDGET,
                'settings' => [],
                'weight' => 2,
            ],
            'type' => BridgeContentType::WYSIWYG_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'users',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 3,
            'title' => [
                'fr' => 'Contact',
                'en' => 'Contact',
                'es' => 'Con tacto',
                'de' => 'Kontakt',
                'pt' => 'Contacto',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 3,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => 'users',
                'cardinality' => -1,
            ],
            'selectable_all' => true,
        ],
        [
            'name' => 'tools',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 4,
            'title' => [
                'fr' => 'Outil',
                'en' => 'Tool',
                'es' => 'Herramienta',
                'de' => 'Werkzeug',
                'pt' => 'Ferramenta',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 4,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['tools'],
                'cardinality' => -1,
            ],
            'selectable_all' => true,
        ],
        [
            'name' => 'blocks',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 5,
            'title' => [
                'fr' => 'Bloc',
                'en' => 'Bloc',
                'es' => 'Bloc',
                'de' => 'Bloc',
                'pt' => 'Bloc',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 5,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['blocks'],
                'cardinality' => -1,
            ],
            'selectable_all' => true,
        ],
        [
            'name' => 'display_movements',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 6,
            'title' => [
                'fr' => 'Mouvements',
                'en' => 'Movement',
                'es' => 'Movimiento',
                'de' => 'Bewegung',
                'pt' => 'Movimentos',
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [
                    'display_label' => true,
                ],
                'weight' => 6,
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => false,
        ],
        [
            'name' => 'news_categories',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 7,
            'title' => [
                'fr' => 'Catégorie(s) de l\'actualité',
                'en' => 'News category(ies)',
                'es' => 'Categoría(s) de noticias',
                'de' => 'News-Kategorie(n)',
                'pt' => 'Categoria(s) da(s) notícia(s)',
            ],
            'description' => [
                'fr' => 'Choix de la (ou des) catégories d\'actualité à remonter sur l\'espace',
                'en' => 'Choice of the news category(ies) to be uploaded in space',
                'es' => 'Elección de la(s) categoría(s) de noticias que se cargarán en el espacio',
                'de' => 'Auswahl der Nachrichtenkategorie(n), die in den Weltraum hochgeladen werden sollen',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 7,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['news_categories'],
                'cardinality' => -1,
            ],
            'selectable_all' => true,
        ],
    ],
];
