<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'news',
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => true,
        'aliasable' => true,
        'permissible' => true,
        'categorizable' => false,
        'listing_type' => 'content',
        'title' => [
            'fr' => 'Actualité',
            'en' => 'News',
            'es' => 'Noticias',
            'de' => 'Nachrichten',
            'pt' => 'Notícias',
        ],
    ],
    'fields' => [
        [
            'name' => 'image',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => true,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 0,
            'title' => [
                'fr' => 'Image principale',
                'en' => 'main picture',
                'es' => 'imagen principal',
                'de' => 'Hauptbild',
                'pt' => 'Imagem principal',
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => 0,
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'chapo',
            'searchable' => true,
            'translatable' => true,
            'search_result_field' => true,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 1,
            'title' => [
                'fr' => 'Introduction',
                'en' => 'Introduction',
                'es' => 'Introducción',
                'de' => 'Einführung',
                'pt' => 'Introdução',
            ],
            'description' => [
                'fr' => 'L\'introduction remonte sur les pages de listing d\'actualité et n\'est pas dupliquée dans votre contenu',
                'en' => 'The introduction goes up on the news listing pages and is not duplicated in your content',
                'es' => 'La introducción sube en las páginas de listado de noticias y no se duplica en su contenido.',
                'de' => 'Die Einführung erscheint auf den Seiten der Nachrichtenliste und wird nicht in Ihren Inhalten dupliziert',
            ],
            'widget' => [
                'type' => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [
                    'rows' => 5,
                    'placeholder' => '',
                ],
                'weight' => 1,
            ],
            'type' => BridgeContentType::TEXTAREA_FIELD,
            'settings' => [
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'content',
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 2,
            'title' => [
                'fr' => 'Contenu',
                'en' => 'Content',
                'es' => 'Contenido',
                'de' => 'Inhalt',
                'pt' => 'Conteúdo',
            ],
            'description' => [
                'fr' => 'Sélectionnez les différents types de paragraphes que vous voulez faire remonter sur la page',
                'en' => 'Select the different types of paragraphs you want to move up the page',
                'es' => 'Seleccione los diferentes tipos de párrafos que desea mover hacia arriba en la página',
                'de' => 'Wählen Sie die verschiedenen Arten von Absätzen aus, die Sie auf der Seite nach oben verschieben möchten',
            ],
            'widget' => [
                'type' => BridgeContentType::SECTION_WIDGET,
                'settings' => [
                    'title' => 'Paragraphe',
                    'title_plural' => 'Paragraphes',
                    'edit_mode' => 'open',
                    'add_mode' => 'dropdown',
                    'form_display_mode' => 'default',
                    'default_paragraph_type' => '',
                ],
                'weight' => 2,
            ],
            'type' => BridgeContentType::SECTION_FIELD,
            'settings' => [
                'target_type' => [
                    'text',
                    'text_two_columns',
                    'text_with_image',
                    'separator',
                    'file',
                    'slider',
                    'image',
                    'video',
                    'map',
                    'accordion',
                    'call_to_action',
                    'button',
                    'html',
                    'tweet',
                    'fetched_contents',
                ],
                'cardinality' => -1,
            ],
        ],
        [
            'name' => 'news_categories',
            'searchable' => true,
            'translatable' => true,
            'search_result_field' => true,
            'searchable_filter' => true,
            'required' => true,
            'weight' => 3,
            'title' => [
                'fr' => 'Catégorie(s) de l\'actualité',
                'en' => 'News category(ies)',
                'es' => 'Categoría(s) de noticias',
                'de' => 'News-Kategorie(n)',
                'pt' => 'Categoria(s) da(s) notícia(s)',
            ],
            'description' => [
                'fr' => 'Sélectionnez la ou les catégorie de cette actualité',
                'en' => 'Sélectionnez la ou les catégorie de cette actualité',
                'es' => 'Sélectionnez la ou les catégorie de cette actualité',
                'de' => 'Sélectionnez la ou les catégorie de cette actualité',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 3,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['news_categories'],
                'cardinality' => -1,
            ],
            'selectable_all' => true,
        ],
        [
            'name' => 'locations',
            'searchable' => true,
            'translatable' => true,
            'search_result_field' => true,
            'searchable_filter' => true,
            'required' => false,
            'weight' => 4,
            'title' => [
                'fr' => 'Site',
                'en' => 'Location',
                'es' => 'Ubicación',
                'de' => 'Standort',
                'pt' => 'Localização',
            ],
            'description' => [
                'fr' => 'Sélectionnez la ou les sites de cette actualité',
                'en' => 'Sélectionnez la ou les sites de cette actualité',
                'es' => 'Sélectionnez la ou les sites de cette actualité',
                'de' => 'Sélectionnez la ou les sites de cette actualité',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 4,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['locations'],
                'cardinality' => -1,
            ],
            'selectable_all' => true,
        ],
        [
            'name' => 'is_featured',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 5,
            'title' => [
                'fr' => 'À la une',
                'en' => 'Featured',
                'es' => 'Presentado',
                'de' => 'Hervorgehoben',
                'pt' => 'Na ribalta',
            ],
            'description' => [
                'fr' => 'Faites remonter l\'actualité à la une sur la page d\'accueil',
                'en' => 'Bring headline news to the homepage',
                'es' => 'Llevar noticias de primera plana a la página de inicio',
                'de' => 'Bringen Sie Schlagzeilen auf die Homepage',
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [
                    'display_label' => true,
                ],
                'weight' => 5,
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => false,
        ],
    ],
];
