<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'documents',
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => true,
        'aliasable' => false,
        'permissible' => true,
        'categorizable' => false,
        'listing_type' => 'content',
        'title' => [
            'fr' => 'Document',
            'en' => 'Document',
            'es' => 'Documento',
            'de' => 'Dokumentieren',
            'pt' => 'Documento',
        ],
    ],
    'fields' => [
        [
            'name' => 'image',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 0,
            'title' => [
                'fr' => 'Image de prévisualisation',
                'en' => 'Preview Image',
                'es' => 'Imagen de vista previa',
                'de' => 'Vorschaubild',
                'pt' => 'Pré-visualizar imagem',
            ],
            'description' => [
                'fr' => 'Cette image sera utilisée comme image de prévisualisation dans un dossier de médiathèque',
                'en' => 'This image will be used as a preview image in a media library folder',
                'es' => 'Esta imagen se utilizará como imagen de vista previa en una carpeta de la biblioteca de medios',
                'de' => 'Dieses Bild wird als Vorschaubild in einem Medienbibliotheksordner verwendet',
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => 0,
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'file',
            'searchable' => true,
            'translatable' => true,
            'search_result_field' => true,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Fichier',
                'en' => 'File',
                'es' => 'Expediente',
                'de' => 'Datei',
                'pt' => 'Ficheiro',
            ],
            'widget' => [
                'type' => BridgeContentType::FILE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                ],
                'weight' => 1,
            ],
            'type' => BridgeContentType::FILE_FIELD,
            'settings' => [
                'display_field' => false,
                'display_default' => false,
                'uri_scheme' => 'public',
                'target_type' => 'file',
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'content',
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 2,
            'title' => [
                'fr' => 'Contenu',
                'en' => 'Content',
                'es' => 'Contenido',
                'de' => 'Inhalt',
                'pt' => 'Conteúdo',
            ],
            'description' => [
                'fr' => 'Sélectionnez les différents types de paragraphes que vous voulez faire remonter sur la page',
                'en' => 'Select the different types of paragraphs you want to move up the page',
                'es' => 'Seleccione los diferentes tipos de párrafos que desea mover hacia arriba en la página',
                'de' => 'Wählen Sie die verschiedenen Arten von Absätzen aus, die Sie auf der Seite nach oben verschieben möchten',
            ],
            'widget' => [
                'type' => BridgeContentType::SECTION_WIDGET,
                'settings' => [
                    'title' => 'Paragraphe',
                    'title_plural' => 'Paragraphes',
                    'edit_mode' => 'open',
                    'add_mode' => 'dropdown',
                    'form_display_mode' => 'default',
                    'default_paragraph_type' => '',
                ],
                'weight' => 2,
            ],
            'type' => BridgeContentType::SECTION_FIELD,
            'settings' => [
                'target_type' => [
                    'text',
                    'text_two_columns',
                    'text_with_image',
                    'separator',
                    'file',
                    'slider',
                    'image',
                    'video',
                    'map',
                    'accordion',
                    'call_to_action',
                    'button',
                    'html',
                    'tweet',
                    'fetched_contents',
                ],
                'cardinality' => -1,
            ],
        ],
        [
            'name' => 'folders',
            'searchable' => true,
            'translatable' => true,
            'search_result_field' => true,
            'searchable_filter' => true,
            'required' => true,
            'weight' => 3,
            'title' => [
                'fr' => 'Dossier parent',
                'en' => 'parent folder',
                'es' => 'carpeta principal',
                'de' => 'übergeordneter Ordner',
                'pt' => 'Ficheiro dos pais',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 3,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['folders'],
                'cardinality' => -1,
            ],
            'selectable_all' => true,
        ],
    ],
];
