<?php

namespace Inside\NCKL\Providers;

use Inside\Content\Events\ContentFullyInsertedEvent;
use Inside\NCKL\Listeners\UserDefaultToolsListener;
use Inside\Support\EventServiceProvider as BaseServiceProvider;
use Psr\Container\ContainerExceptionInterface;
use Psr\Container\NotFoundExceptionInterface;

/**
 * NCKL Service provider.
 *
 * @category Class
 * @package  Inside\\NCKL\Providers\ServiceProvider
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class ServiceProvider extends BaseServiceProvider
{
    protected array $listen = [
        ContentFullyInsertedEvent::class => [
            UserDefaultToolsListener::class,
        ],
    ];

    public function register(): void
    {
        try {
            $this->mergeRecursiveConfigFrom(__DIR__ . '/../../config/scheduler.php', 'scheduler');
            $this->mergeConfigTo(__DIR__.'/../../config/statistics.php', 'statistics');
            $this->mergeConfigTo(__DIR__.'/../../config/notify.php', 'notify');
            $this->mergeConfigTo(__DIR__ . '/../../config/import.php', 'import');
            $this->mergeConfigTo(__DIR__.'/../../config/ldap_auth.php', 'ldap_auth');
        } catch (NotFoundExceptionInterface|ContainerExceptionInterface) {
        }
    }
}
