<?php

namespace Inside\NCKL\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Inside\Content\Events\ContentFullyInsertedEvent;
use Inside\Content\Models\Contents\Tools;
use Inside\Content\Models\Contents\Users;
use Inside\Host\Bridge\BridgeContent;

class UserDefaultToolsListener implements ShouldQueue
{
    public function handle(ContentFullyInsertedEvent $event): void
    {
        if (!$event->model instanceof Users) {
            return;
        }

        $user = $event->model;

        $defaultToolsTitles = [
            'Helpdesk',
            'Nickel People',
            'Gmail',
            'Poser mes congés',
            'Boîte idées',
        ];

        $bridge = new BridgeContent();
        $defaultTools = Tools::query()->whereIn('title', $defaultToolsTitles)
            ->get()
            ->sortBy(fn (Tools $tool) => array_search($tool->title, $defaultToolsTitles));

        $tools = $defaultTools->where('langcode', $user->langcode)->pluck('uuid');
        $userTools = $user->tools->pluck('uuid')->reject(fn (string $uuid) => $tools->contains($uuid));

        $bridge->contentUpdate('users', [
            'uuid' => $user->uuid,
            'tools' => $tools->concat($userTools)->all(),
        ]);
    }
}
