<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

final class AddToolsCategoriesListings extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);


        $type = \Drupal::entityTypeManager()->getStorage('node_type')->load('tools_categories_listings');

        if (!empty($type)) {
            return;
        }
        $this->migrateContent('tools_categories_listings', false);
        $this->migrateContent('tools_categories', false);

        $this->finishUp();
    }
}
