<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Schema;
use Inside\Content\Facades\Schema as InsideSchema;

final class FixDefaultWeightSections extends Migration
{
    public function up(): void
    {
        $sections = InsideSchema::getSectionTypes();

        foreach ($sections as $section) {
            Schema::table(section_type_to_table($section), function ($table) {
                $table->integer('weight')->default(0)->change();
            });
        }
    }
}
