<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class TransformUuidInBpchar extends Migration
{
    public function up(): void
    {
        Schema::table('inside_menu_header', function (Blueprint $table) {
            $table->dropForeign('inside_menu_header_parent_uuid_foreign');
        });

        Schema::table('inside_menu_footer', function (Blueprint $table) {
            $table->dropForeign('inside_menu_footer_parent_uuid_foreign');
        });

        DB::statement("ALTER TABLE inside_menu_header ALTER COLUMN uuid TYPE bpchar(36) USING uuid::bpchar;");
        DB::statement("ALTER TABLE inside_menu_footer ALTER COLUMN uuid TYPE bpchar(36) USING uuid::bpchar;");
        DB::statement("ALTER TABLE inside_menu_header ALTER COLUMN parent_uuid TYPE bpchar(36) USING parent_uuid::bpchar;");
        DB::statement("ALTER TABLE inside_menu_footer ALTER COLUMN parent_uuid TYPE bpchar(36) USING parent_uuid::bpchar;");

        Schema::table('inside_menu_header', function (Blueprint $table) {
            $table->foreign('parent_uuid')->references('uuid')->on('inside_menu_header')->onDelete('set null');
        });

        Schema::table('inside_menu_footer', function (Blueprint $table) {
            $table->foreign('parent_uuid')->references('uuid')->on('inside_menu_footer')->onDelete('set null');
        });
    }
}
