<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Notify\Models\NotificationType;

class FixMissingExportNotification extends Migration
{
    public function up(): void
    {
        NotificationType::firstOrCreate(
            [
                'via'       => 'web',
                'default'   => false,
                'type'      => 'system',
                'event'     => null,
                'model'     => null,
                'action'    => 'export',
                'condition' => null,
                'multiple'  => true,
                'language'  => false,
                'profile'   => false,
            ],
            [
                'data' => [
                    'title'       => 'notifications.content.export.title',
                    'description' => 'notifications.content.export.description',
                    'text'        => 'notifications.content.export.text',
                ],
            ]
        );
    }
}
