<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Custom;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

class DeleteContentTypesFields extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__DIR__);

        $fieldsToDelete = [
            'weekly_news' => ['is_featured'],
            'jt_news' => ['is_featured'],
            'spaces' => ['presentation', 'users'],
        ];

        foreach ($fieldsToDelete as $type => $fields) {
            foreach ($fields as $field) {
                $this->getBridge()?->contentTypeDeleteField('node', $type, $field);
            }
        }

        $this->finishUp();
    }
}
