<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Custom;
use Inside\Host\Bridge\BridgeContent;

class CreateCustoms extends Migration
{
    private function createCustom(BridgeContent $bridge, array $fields, string $langcode, ?string $uuidHost = null): ?string
    {
        if (!isset($fields['title'][$langcode])) {
            return null;
        }

        $customFields = [
            'custom_slug' => $fields['custom_slug'],
            'redirection_page' => $fields['redirection_page'],
            'title' => $fields['title'][$langcode],
            'langcode' => $langcode,
        ];

        if ($uuidHost) {
            $customFields['uuid_host'] = $uuidHost;
        }

        $uuid = Custom::query()
            ->where('custom_slug', $fields['custom_slug'])
            ->where('langcode', $langcode)
            ->first()
            ?->uuid;

        if ($uuid) {
            $customFields['uuid'] = $uuid;
        }

        return $bridge->contentInsert('custom', $customFields, $uuid === null);
    }

    public function up(): void
    {
        $customs = [
            [
                'custom_slug' => 'news',
                'redirection_page' => 'NewsListingPage',
                'title' => [
                    'fr' => 'LES ACTUALITÉS',
                    'en' => 'THE NEWS',
                    'es' => 'LAS ACTUALIDADES',
                    'de' => 'DIE NACHRICHTEN',
                    'pt' => 'AS NOTÍCIAS',
                ],
            ],
            [
                'custom_slug' => 'calendar',
                'redirection_page' => 'EventsCalendarPage',
                'title' => [
                    'fr' => 'ÉVÈNEMENTS',
                    'en' => 'EVENTS',
                    'es' => 'EVENTOS',
                    'de' => 'VERANSTALTUNGEN',
                    'pt' => 'EVENTOS',
                ],
            ],
            [
                'custom_slug' => 'ged',
                'redirection_page' => 'GedPage',
                'title' => [
                    'fr' => 'BIBLIOTHÈQUE',
                    'en' => 'LIBRARY',
                    'es' => 'BIBLIOTECA',
                    'de' => 'BÜCHEREI',
                    'pt' => 'BIBLIOTECA',
                ],
            ],
            [
                'custom_slug' => 'tools',
                'redirection_page' => 'ToolsPage',
                'title' => [
                    'fr' => 'MES APPS',
                    'en' => 'MY APPS',
                    'es' => 'MIS APLICACIONES',
                    'de' => 'MEINE APPLIKATIONEN',
                    'pt' => 'MEUS APLICATIVOS',
                ],
            ],
            [
                'custom_slug' => 'jt_news',
                'redirection_page' => 'JTNewsListingPage',
                'title' => [
                    'fr' => 'JT NICKEL',
                    'en' => 'JT NICKEL',
                    'es' => 'JT NICKEL',
                    'de' => 'JT NICKEL',
                    'pt' => 'JT NICKEL',
                ],
            ],
            [
                'custom_slug' => 'weekly_news',
                'redirection_page' => 'WeeklyNewsListingPage',
                'title' => [
                    'fr' => 'HEBDOS',
                    'en' => 'WEEKLIES',
                    'es' => 'SEMANARIOS',
                    'de' => 'WÖCHENTLICH',
                    'pt' => 'SEMANAIS',
                ],
            ],
            [
                'custom_slug' => 'offers',
                'redirection_page' => 'OffersListingPage',
                'title' => [
                    'fr' => 'PETITES ANNONCES',
                    'en' => 'OFFERS',
                    'es' => 'OFERTAS',
                    'de' => 'BIETET AN',
                    'pt' => 'OFERTAS',
                ],
            ],
        ];

        $locale = config('app.locale');
        $langs = list_languages();
        $bridge = new BridgeContent();

        foreach ($customs as $custom) {
            $originalUuid = $this->createCustom($bridge, $custom, $locale);
            $original = Custom::find($originalUuid);

            if ($original === null) {
                continue;
            }


            foreach ($langs as $lang) {
                if ($lang !== $locale) {
                    $this->createCustom($bridge, $custom, $lang, $original->uuid_host);
                }
            }
        }
    }
}
