<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'users',
        'translatable' => false,
        'searchable' => false,
        'global_searchable' => false,
        'aliasable' => false,
        'permissible' => false,
        'categorizable' => false,
        'listing_type' => 'hidden',
        'title' => [
            'fr' => 'Utilisateur',
            'en' => 'User',
            'es' => 'Usuario',
            'de' => 'Benutzer',
            'pt' => 'Utilizador',
        ],
    ],
    'fields' => [
        [
            'name' => 'image',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => true,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 0,
            'title' => [
                'fr' => 'Photo de profil',
                'en' => 'Profile picture',
                'es' => 'Foto de perfil',
                'de' => 'Profilbild',
                'pt' => 'Foto de perfil',
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => 0,
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'firstname',
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => true,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Prénom',
                'en' => 'First name',
                'es' => 'Nombre',
                'de' => 'Vorname',
                'pt' => 'Primeiro nome',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 1,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'lastname',
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => true,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 2,
            'title' => [
                'fr' => 'Nom',
                'en' => 'Last name',
                'es' => 'Apellido',
                'de' => 'Nachname',
                'pt' => 'Nome',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 2,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'function',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => true,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 3,
            'title' => [
                'fr' => 'Fonction',
                'en' => 'Function',
                'es' => 'Función',
                'de' => 'Funktion',
                'pt' => 'Função',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 3,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'phone',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 4,
            'title' => [
                'fr' => 'Téléphone',
                'en' => 'Phone',
                'es' => 'Teléfono',
                'de' => 'Telefon',
                'pt' => 'Telefone',
            ],
            'widget' => [
                'type' => BridgeContentType::INSIDE_PHONE_WIDGET,
                'weight' => 4,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'mobile_phone',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 5,
            'title' => [
                'fr' => 'Mobile',
                'en' => 'Mobile phone',
                'es' => 'Teléfono móvil',
                'de' => 'Handy',
                'pt' => 'Telemóvel',
            ],
            'widget' => [
                'type' => BridgeContentType::INSIDE_PHONE_WIDGET,
                'weight' => 5,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'locations',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => true,
            'required' => false,
            'weight' => 6,
            'title' => [
                'fr' => 'Site',
                'en' => 'Location',
                'es' => 'Ubicación',
                'de' => 'Standort',
                'pt' => 'Localização',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 6,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['locations'],
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'tools',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 7,
            'title' => [
                'fr' => 'Accès rapides',
                'en' => 'Quick access',
                'es' => 'Acceso rapido',
                'de' => 'Schneller Zugang',
                'pt' => 'Acesso rápido',
            ],
            'widget' => [
                'type' => BridgeContentType::OPTIONS_BUTTONS_WIDGET,
                'settings' => [],
                'weight' => 7,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['tools'],
                'cardinality' => -1,
            ],
        ],
        [
            'name' => 'is_maintenance',
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => true,
            'required' => false,
            'weight' => 8,
            'title' => [
                'fr' => 'Compte de maintenance ?',
                'en' => 'Maintenance account?',
                'es' => 'cuenta de mantenimiento?',
                'de' => 'Wartungskonto?',
                'pt' => 'Conta de manutenção?',
            ],
            'description' => [
                'fr' => 'Si cette case est cochée l\'utilisateur ne remontera pas dans l\'annuaire de l\'intranet',
                'en' => 'If this box is checked the user will not go up in the intranet directory',
                'es' => 'Si esta casilla está marcada el usuario no subirá en el directorio de la intranet',
                'de' => 'Wenn dieses Kontrollkästchen aktiviert ist, gelangt der Benutzer nicht in das Intranet-Verzeichnis',
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [
                    'display_label' => true,
                ],
                'weight' => 8,
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => false,
        ],
        [
            'name' => 'send_mail',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 9,
            'title' => [
                'fr' => 'Envoyer un mail à la création de mot de passe',
                'en' => 'Send email to password creation',
                'es' => 'Enviar correo electrónico a la creación de contraseña',
                'de' => 'E-Mail zur Passworterstellung senden',
                'pt' => 'Enviar um e-mail para criar uma palavra-passe',
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [
                    'display_label' => true,
                ],
                'weight' => 9,
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => false,
        ],
        [
            'name' => 'is_gdpr_compliant',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 10,
            'title' => [
                'fr' => 'RGPD Compliant',
                'en' => 'RGPD Compliant',
                'es' => 'RGPD Compliant',
                'de' => 'RGPD Compliant',
                'pt' => 'RGPD Compliant',
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [
                    'display_label' => true,
                ],
                'weight' => 10,
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => false,
        ],
    ],
];
