<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'spaces_pages',
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => false,
        'aliasable' => false,
        'permissible' => false,
        'categorizable' => false,
        'listing_type' => 'content',
        'title' => [
            'fr' => 'Page espace',
            'en' => 'Space page',
            'es' => 'página de espacio',
            'de' => 'Space-Seite',
            'pt' => 'Espaço da página',
        ],
    ],
    'fields' => [
        [
            'name' => 'spaces_tabs',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 0,
            'title' => [
                'fr' => 'Regroupement de page',
                'en' => 'Page grouping',
                'es' => 'Agrupación de páginas',
                'de' => 'Seitengruppierung',
                'pt' => 'Agrupamento de páginas',
            ],
            'description' => [
                'fr' => 'Choix du regroupement de page dans lequel la page doit remonter',
                'en' => 'Choice of the page group in which the page must go up',
                'es' => 'Elección del grupo de páginas en el que debe subir la página',
                'de' => 'Wahl der Seitengruppe, in der die Seite nach oben gehen muss',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 0,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['spaces_tabs'],
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'weight',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Ordre d\'affichage',
                'en' => 'order of appearance',
                'es' => 'orden de aparición',
                'de' => 'Reihenfolge des Erscheinens',
                'pt' => 'Ordem de exibição',
            ],
            'description' => [
                'fr' => 'Le chiffre le plus bas remonte en 1er',
                'en' => 'The lowest number goes up in 1st',
                'es' => 'El número más bajo sube en 1er.',
                'de' => 'Die niedrigste Zahl steigt in 1.',
            ],
            'widget' => [
                'type' => BridgeContentType::NUMBER_WIDGET,
                'settings' => [],
                'weight' => 1,
            ],
            'type' => BridgeContentType::INTEGER_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => 0,
        ],
        [
            'name' => 'content',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 2,
            'title' => [
                'fr' => 'Contenu',
                'en' => 'Content',
                'es' => 'Contenido',
                'de' => 'Inhalt',
                'pt' => 'Conteúdo',
            ],
            'description' => [
                'fr' => 'Sélectionnez les différents types de paragraphes que vous voulez faire remonter sur la page',
                'en' => 'Select the different types of paragraphs you want to move up the page',
                'es' => 'Seleccione los diferentes tipos de párrafos que desea mover hacia arriba en la página',
                'de' => 'Wählen Sie die verschiedenen Arten von Absätzen aus, die Sie auf der Seite nach oben verschieben möchten',
            ],
            'widget' => [
                'type' => BridgeContentType::SECTION_WIDGET,
                'settings' => [
                    'title' => 'Paragraphe',
                    'title_plural' => 'Paragraphes',
                    'edit_mode' => 'open',
                    'add_mode' => 'dropdown',
                    'form_display_mode' => 'default',
                    'default_paragraph_type' => '',
                ],
                'weight' => 2,
            ],
            'type' => BridgeContentType::SECTION_FIELD,
            'settings' => [
                'target_type' => [
                    'text',
                    'text_two_columns',
                    'text_with_image',
                    'separator',
                    'file',
                    'slider',
                    'image',
                    'video',
                    'map',
                    'accordion',
                    'call_to_action',
                    'button',
                    'html',
                    'tweet',
                    'fetched_contents',
                ],
                'cardinality' => -1,
            ],
        ],
    ],
];
