<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'social_blocks',
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => false,
        'aliasable' => false,
        'permissible' => true,
        'categorizable' => false,
        'listing_type' => 'content',
        'title' => [
            'fr' => 'Bloc social',
            'en' => 'Social block',
            'es' => 'Bloque social',
            'de' => 'Sozialer block',
            'pt' => 'Bloco social',
        ],
    ],
    'fields' => [
        [
            'name' => 'image',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 0,
            'title' => [
                'fr' => 'Image',
                'en' => 'Image',
                'es' => 'Imagen',
                'de' => 'Bild',
                'pt' => 'Imagem',
            ],
            'description' => [
                'fr' => 'L\'icone remontera sur la gauche du bloc, si une image est complétée l\'icone ne remontera pas',
                'en' => 'The icon will go up on the left of the block, if an image is completed the icon will not go up',
                'es' => 'El icono subirá a la izquierda del bloque, si se completa una imagen el icono no subirá',
                'de' => 'Das Symbol wird auf der linken Seite des Blocks angezeigt, wenn ein Bild fertig ist, wird das Symbol nicht angezeigt',
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => 0,
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'icon',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 1,
            'title' => [
                'fr' => 'Icone',
                'en' => 'Icon',
                'es' => 'Icono',
                'de' => 'Symbol',
                'pt' => 'Ícone',
            ],
            'widget' => [
                'type' => BridgeContentType::INSIDE_ICON_PICKER_WIDGET,
                'settings' => [],
                'weight' => 1,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'dark_mode',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 2,
            'title' => [
                'fr' => 'Dark mode',
                'en' => 'Dark mode',
                'es' => 'Dark mode',
                'de' => 'Dark mode',
                'pt' => 'Dark mode',
            ],
            'description' => [
                'fr' => 'Si le dark mode est activé, le texte et l\'icone seront blancs',
                'en' => 'If the dark mode is activated, the text and the icon will be white',
                'es' => 'Si el modo oscuro está activado, el texto y el icono serán de color blanco.',
                'de' => 'Wenn der Dunkelmodus aktiviert ist, sind der Text und das Symbol weiß',
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [
                    'display_label' => true,
                ],
                'weight' => 2,
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => true,
        ],
        [
            'name' => 'link',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 3,
            'title' => [
                'fr' => 'Lien',
                'en' => 'Link',
                'es' => 'Enlace',
                'de' => 'Verknüpfung',
                'pt' => 'Ligação',
            ],
            'widget' => [
                'type' => BridgeContentType::INSIDE_LINK_WIDGET,
                'settings' => [],
                'weight' => 3,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'link_label',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 4,
            'title' => [
                'fr' => 'Texte du lien',
                'en' => 'Link text',
                'es' => 'Texto del enlace',
                'de' => 'Link Text',
                'pt' => 'Texto da ligação',
            ],
            'description' => [
                'fr' => 'Si aucun texte n\'est rempli alors le bloc complet sera cliquable',
                'en' => 'If no text is filled then the complete block will be clickable',
                'es' => 'Si no se completa ningún texto, se podrá hacer clic en el bloque completo',
                'de' => 'Wenn kein Text ausgefüllt ist, ist der komplette Block anklickbar',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 4,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'weight',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 5,
            'title' => [
                'fr' => 'Ordre d\'affichage',
                'en' => 'order of appearance',
                'es' => 'orden de aparición',
                'de' => 'Reihenfolge des Erscheinens',
                'pt' => 'Ordem de exibição',
            ],
            'description' => [
                'fr' => 'Le chiffre le plus bas remonte en 1er',
                'en' => 'The lowest number goes up in 1st',
                'es' => 'El número más bajo sube en 1er.',
                'de' => 'Die niedrigste Zahl steigt in 1.',
            ],
            'widget' => [
                'type' => BridgeContentType::NUMBER_WIDGET,
                'settings' => [],
                'weight' => 5,
            ],
            'type' => BridgeContentType::INTEGER_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => 0,
        ],
    ],
];
