<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'folders',
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => true,
        'aliasable' => false,
        'permissible' => true,
        'categorizable' => true,
        'listing_type' => 'taxo',
        'title' => [
            'fr' => 'Dossier',
            'en' => 'Folder',
            'es' => 'Carpetas',
            'de' => 'Mappe',
            'pt' => 'Ficheiro',
        ],
    ],
    'fields' => [
        [
            'name' => 'image',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 0,
            'title' => [
                'fr' => 'Image',
                'en' => 'Image',
                'es' => 'Imagen',
                'de' => 'Bild',
                'pt' => 'Imagem',
            ],
            'description' => [
                'fr' => 'Cette image remontera dans la page mère de l\'espace documentaire',
                'en' => 'This image goes up in the main page of the documentary space',
                'es' => 'Esta imagen sube en la página principal del espacio documental',
                'de' => 'Dieses Bild erscheint auf der Hauptseite des Dokumentarbereichs',
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => 0,
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'is_media_folder',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Dossier médiathèque',
                'en' => 'Media library folder',
                'es' => 'Carpeta de la biblioteca de medios',
                'de' => 'Ordner Medienbibliothek',
                'pt' => 'Ficheiro da mediateca',
            ],
            'description' => [
                'fr' => 'Si le dossier est catégorisé comme médiathèque les fichiers à l\'intérieur se présenteront sous la forme d\'une médiathèque',
                'en' => 'If the folder is categorized as a media library the files inside will appear as a media library',
                'es' => 'Si la carpeta está categorizada como una biblioteca de medios, los archivos que contiene aparecerán como una biblioteca de medios.',
                'de' => 'If the folder is categorized as a media library the files inside will appear as a media library',
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [
                    'display_label' => true,
                ],
                'weight' => 1,
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => false,
        ],
        [
            'name' => 'folders',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 2,
            'title' => [
                'fr' => 'Dossier parent',
                'en' => 'parent folder',
                'es' => 'carpeta principal',
                'de' => 'übergeordneter Ordner',
                'pt' => 'Ficheiro dos pais',
            ],
            'description' => [
                'fr' => 'Si le dossier n\'a pas de dossier parent, il remonte sur la page principale de la GED',
                'en' => 'If the folder does not have a parent folder, it goes back to the main page of the document base',
                'es' => 'Si la carpeta no tiene una carpeta principal, vuelve a la página principal de la base del documento.',
                'de' => 'Wenn der Ordner keinen übergeordneten Ordner hat, geht er zurück auf die Hauptseite der Dokumentenbasis',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 2,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['folders'],
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'color',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 3,
            'title' => [
                'fr' => 'Couleur',
                'en' => 'Color',
                'es' => 'Color',
                'de' => 'Farbe',
                'pt' => 'Cor',
            ],
            'description' => [
                'fr' => 'Sélectionnez la couleur de votre dossier',
                'en' => 'Select your folder color',
                'es' => 'Selecciona el color de tu carpeta',
                'de' => 'Wählen Sie Ihre Ordnerfarbe',
            ],
            'widget' => [
                'type' => BridgeContentType::INSIDE_COLOR_PICKER_WIDGET,
                'settings' => [],
                'weight' => 3,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
    ],
];
