<?php

return [
    'types'  => [
        'jt_news'      => [
            'category' => false,
            'comments' => false,
            'likes'    => false,
        ],
        'weekly_news'    => [
            'category' => false,
            'comments' => false,
            'likes'    => false,
        ],
        'pages'    => [
            'category' => null,
            'comments' => false,
            'likes'    => false,
        ],
        'news'      => [
            'category' => 'news_categories',
            'comments' => false,
            'likes'    => true,
        ],
        'documents' => [
            'category' => 'folders',
            'comments' => false,
            'likes'    => true,
        ],
        'events'    => [
            'category' => 'events_categories',
            'comments' => false,
            'likes'    => true,
        ],
    ],
    'export' => [
        'contents'       => [
            'headers'    => [
                'uuid'         => 'UUID',
                'content_type' => 'Content type',
                'title'        => 'Title',
                'edit'         => 'Edit link',
            ],
            'presenters' => [
                'edit' => function ($value, $model) {
                    return env('APP_URL').'/edit/'.class_to_type($model).'/'.$model->uuid;
                },
            ],
        ],
        'users'          => [
            'headers' => [
                'email'     => 'Mail address',
                'full_name' => 'Full name',
            ],
        ],
        'user_visits' => [
            'headers'    => [],
        ],
        'authentication' => [
            'headers' => [],
        ],
    ],
];
