<?php

use Adldap\Models\Entry;

return [
    'usernames' => [
        'ldap' => [
            'discover' => env('ADLDAP_LDAP_DISCOVER', 'displayname'),
            'authenticate' => env('ADLDAP_LDAP_AUTHENTICATE', 'mail'),
        ],
        'eloquent' => env('ADLDAP_ELOQUENT_VALUE', 'email'),
    ],
    'discovering_attributes' => 'displayname',
    'sync_attributes' => [
        'email' => 'mail',
        'name' => 'displayname',
        'firstname' => 'givenname',
        'lastname' => 'sn',
        'fullname' => 'displayname',
        'locations' => fn (Entry $user) => reference('locations')->from($user->dncity[0])->get(),
        'langcode' => fn (Entry $user) => match ($user->dncountry[0]) {
            'Espagne' => 'es',
            'Portugal' => 'pt',
            'Belgique' => 'en',
            'Allemagne' => 'de',
            default => 'fr',
        },
    ]
];
