<?php

return [
    'postfilter' => function ($users) {
        return $users
            ->filter(
                fn ($user) => collect(explode(',', env('NCKL_INCLUDED_OU', '')))
                ->map(fn (string $ou) => sprintf('OU=Users,OU=Accounts,OU=%s,OU=%s,%s', str($ou)->before(':'), str($ou)->after(':'), env('ADLDAP_BASE_DN', 'DC=fpe-ppd,DC=local')))
                ->some(fn (string $ou) => str($user->distinguishedname[0])->endsWith($ou))
            )
            ->map(function ($user) {
                $dn = str($user->distinguishedname[0])
                    ->after('OU=Users,OU=Accounts')
                    ->before('DC=')
                    ->explode(',')
                    ->filter()
                    ->values()
                    ->map(fn (string $ou) => str_replace('OU=', '', $ou));

                $user->dncity = [$dn[0]];
                $user->dncountry = [$dn[1]];

                return $user;
            });
    },
];
