import SpacePage from '@inside-customs/pages/spaces/SpacePage'
import SpacePagesPage from '@inside-customs/pages/spaces/SpacePagesPage'

import { fetchSpace, fetchSpacePagesPage } from '../pages/spaces/fetch'
import { withFetch } from 'inside-collection/hocs'

export default [
  {
    name: 'HomePage',
    meta: { disabled: false, isCustomPage: true }
  },
  {
    name: 'EventsCalendarPage',
    meta: { disabled: false }
  },
  {
    name: 'EventPage',
    meta: { disabled: false }
  },
  {
    name: 'NewsCategoriesListingPage',
    meta: { disabled: false }
  },
  {
    name: 'NewsCategoriesPage',
    meta: { disabled: false }
  },
  {
    name: 'NewsListingPage',
    meta: { disabled: false }
  },
  {
    name: 'NewsPage',
    meta: { disabled: false }
  },
  {
    name: 'GedPage',
    meta: { disabled: false },
    props: {
      cardOverlayEnabled: false,
      extraFilters: {
        sort: 'weight:asc'
      }
    }
  },
  {
    name: 'DirectoryPage',
    component: () => import('../pages/directory/DirectoryPage'),
    meta: { disabled: false }
  },
  {
    name: 'ToolsPage',
    meta: { disabled: false },
    props: {
      requestFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      },
      toolsFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      }
    }
  },
  {
    name: 'SimplePage',
    meta: { disabled: false }
  },
  {
    name: 'TabsSpacePage',
    meta: { disabled: false }
  },
  {
    name: 'SpacePage',
    component: withFetch(SpacePage, { size: 'xxl', watch: true })(fetchSpace),
    path: '/espaces/:slug'
  },
  {
    name: 'SpacePagesPage',
    path: '/espace/pages/:slug',
    component: withFetch(SpacePagesPage, { size: 'xxl' })(fetchSpacePagesPage)
  },
  {
    name: 'FAQListingPage',
    meta: { disabled: false }
  },
  {
    name: 'FormPage',
    meta: { disabled: true }
  },
  {
    name: 'WallsListingPage',
    meta: { disabled: false }
  },
  {
    name: 'WallPage',
    meta: { disabled: false }
  },
  {
    name: 'AdminAdvancedSettingsWeatherPage',
    meta: { admin: true, display: true }
  }
]
