import { markRaw } from 'vue'

import { IconText } from 'inside-collection/atoms'

import { $_formatDate } from '@inside-library/helpers/global-methods/dates'

export default {
  'inside-archives': {
    isEnabled: true
  },
  'inside-edition': {
    revisionEnabled: true,
    duplicateEnabled: true
  },
  'inside-events': {
    subscriptionEnabled: true,
    showBookmarks: true,
    bookmarkEnabled: true
  },
  'inside-jobs': {
    extraFields: ['published_at', { localisations: ['uuid', 'title'] }],
    categoriesFields: [
      {
        contracts_types: {
          fields: ['uuid', 'title', 'color'],
          filters: { 'status:eq': 1 }
        }
      },
      {
        localisations: {
          fields: ['title', 'uuid'],
          filters: { 'status:eq': 1, sort: 'title:asc' }
        }
      }
    ],
    cardOverrides: (data, { addItemAfter }) => {
      addItemAfter('contract', [
        {
          id: 'localisation',
          class: 'localisation',
          tag: markRaw(IconText),
          data: { icon: 'address' },
          value: data?.localisations?.title,
          hideIf: () => !data?.localisations
        },
        {
          id: 'publishedAt',
          class: 'publishedAt',
          tag: markRaw(IconText),
          data: { icon: 'calendar' },
          value: $_formatDate(data?.published_at)
        }
      ])
    }
  },
  'inside-layouts': {
    tabsPagesBookmarkEnabled: true,
    pagesBookmarkEnabled: true,
    gdprContent: 'popins',
    addContentTypes: {
      homepage: [
        'tools',
        'jobs_offers',
        'flash_news',
        'events',
        'news',
        'blocks',
        'cards_links',
        'movements',
        'documents'
      ]
    }
  },
  'inside-news': {
    minimalDate: true,
    bookmarkEnabled: true,
    showBookmarks: true
  },
  'inside-users': {
    csvImport: true,
    shortcuts: {
      max: 6
    },
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'shortcuts', restrictions: [], icon: 'news' },
        { name: 'bookmarks', restrictions: [], icon: 'bookmark' },
        { name: 'notifications', restrictions: [], icon: 'bell' }
      ]
    },
    paragraphs: {
      fetchedContents: {
        display: () => import('./components/users/UserCard'),
        requestFields: [
          'uuid',
          'firstname',
          'lastname',
          'phone',
          'image',
          { functions: ['uuid', 'title'] }
        ]
      }
    }
  },
  'inside-newcomers': {
    extraFields: [
      {
        field: { functions: ['uuid', 'title'] },
        class: 'function',
        data: data => data?.functions?.data.map(fn => fn.title).join(', ') || ''
      }
    ]
  },
  'inside-organizational-chart': {
    functionKey: 'functions'
  },
  'inside-workflows': {
    isEnabled: true
  }
}
