import { http } from '@inside-library/helpers/Http'

export default {
  spaces: {
    add: async ({ data }) => {
      const { data: space } = await http.get('content/spaces', {
        fields: ['uuid', 'title', 'slug'],
        filters: { 'uuid:eq': data.uuid }
      })

      return {
        name: 'SpacePage',
        params: { slug: space?.[0]?.slug?.[0] }
      }
    }
  },
  pagesCategories: {
    add: async ({ data }) => {
      const { data: category } = await http.get('content/pages_categories', {
        fields: ['uuid', 'title', { spaces: ['uuid', 'title', 'slug'] }],
        filters: { 'uuid:eq': data.uuid }
      })

      return {
        name: 'SpacePage',
        params: { slug: category?.[0]?.spaces?.slug?.[0] }
      }
    },
    delete: async ({ data }) => {
      const { data: category } = await http.get('content/pages_categories', {
        fields: ['uuid', 'title', { spaces: ['uuid', 'title', 'slug'] }],
        filters: { 'uuid:eq': data.uuid }
      })

      return {
        name: 'SpacePage',
        params: { slug: category?.[0]?.spaces?.slug?.[0] }
      }
    },
    globalSearch: async ({ data }) => {
      const { data: category } = await http.get('content/pages_categories', {
        fields: ['uuid', { spaces: ['uuid', 'title', 'slug'] }],
        filters: { 'uuid:eq': data.uuid }
      })

      return {
        route: {
          name: 'SpacePagesPage',
          params: {
            slug: category?.[0]?.spaces?.slug?.[0]
          }
        }
      }
    }
  },
  spacesPages: {
    add: async ({ data }) => {
      const { data: page } = await http.get('content/spaces_pages', {
        fields: [
          'uuid',
          { pages_categories: [{ spaces: ['uuid', 'title', 'slug'] }] }
        ],
        filters: { 'uuid:eq': data.uuid }
      })

      return {
        name: 'SpacePagesPage',
        params: {
          slug: page?.[0]?.pages_categories?.spaces?.slug?.[0]
        },
        query: { page: data.uuid }
      }
    },
    delete: async ({ uuid }) => {
      const { data: page } = await http.get('content/spaces_pages', {
        fields: [
          'uuid',
          { pages_categories: [{ spaces: ['uuid', 'title', 'slug'] }] }
        ],
        filters: { 'uuid:eq': uuid }
      })

      return {
        name: 'SpacePage',
        params: {
          slug: page?.[0]?.pages_categories?.spaces?.slug?.[0]
        }
      }
    }
  },
  globalSearch: async ({ data }) => {
    const { data: pages } = await http.get('content/spaces_pages', {
      fields: ['uuid', { pages_categories: ['uuid', 'title'] }],
      filters: { 'uuid:eq': data.uuid }
    })

    const { data: category } = await http.get('content/pages_categories', {
      fields: ['uuid', { spaces: ['uuid', 'title', 'slug'] }],
      filters: { 'uuid:eq': pages?.[0]?.pages_categories?.uuid }
    })

    return {
      route: {
        name: 'SpacePagesPage',
        params: {
          slug: category?.[0]?.spaces?.slug[0]
        },
        query: { page: data.uuid }
      }
    }
  }
}
