<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Bridge\BridgeContentType;

class EditCardinalityToolsCategories extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeDeleteField(
            entityType: 'node',
            type: 'tools_categories',
            fieldName: 'tools_categories_listings',
        );

        $bridge->contentTypeCreateOrUpdateField(
            type: 'tools_categories',
            fieldName: 'tools_categories_listings',
            options: [
                'name' => 'tools_categories_listings',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 1,
                'title' => [
                    'fr' => 'Listing d\'outils',
                    'en' => 'Tool List',
                    'nl' => 'Gereedschapslijst',
                    'pt' => 'Lista de ferramentas',
                    'es' => 'Lista de herramientas',
                    'de' => 'Werkzeugliste',
                ],
                'description' => [
                    'fr' => 'Choisissez le listing d\'outils dans lequel cette catégorie doit remonter',
                    'en' => 'Choose the tools listing in which this category should go',
                    'nl' => 'Kies de toolslijst waarin deze categorie moet komen',
                    'pt' => 'Escolha a listagem de ferramentas na qual esta categoria deve ir',
                    'es' => 'Elija el listado de herramientas en el que debe ir esta categoría',
                    'de' => 'Wählen Sie die Werkzeugliste aus, in die diese Kategorie aufgenommen werden soll',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 1,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['tools_categories_listings'],
                    'cardinality' => 1,
                ],
            ],
            weight: -3
        );

        Artisan::call('models:rebuild');
    }
}
