<?php

return [
    'sync_attributes' => [
        'name'  => 'mail',
        'email' => 'mail',
        'firstname' => 'givenName',
        'lastname' => 'surname',
        'phone' => fn (mixed $user) => $user->businessPhones[0] ?? "",
        'mobile_phone' => 'mobilePhone',
        'functions' => fn (mixed $user) => reference('functions')
            ->identifiedBy('code')
            ->from(ucfirst(trim($user->jobTitle)))
            ->get(),
        'services' => fn (mixed $user) => reference('services')
            ->identifiedBy('code')
            ->from(ucfirst(trim($user->department)))
            ->get(),
        'localisations' => fn (mixed $user) => reference('localisations')
            ->identifiedBy('code')
            ->from(ucfirst(trim($user->officeLocation)))
            ->get(),
        'manager' => fn (mixed $user) => reference('users')
            ->identifiedBy('email')
            ->from($user->manager)
            ->withoutCreation()
            ->first(),
        'team_links' => fn (mixed $user) => "https://teams.microsoft.com/l/chat/0/0?users=$user->mail",
    ],
    'custom_attributes' => [
        'manager' => 'userPrincipalName',
    ]
];
