<?php

return [
    '_meta' => [
        'type' => 'newsletters',
        'name' => 'Newsletter',
    ],
    'logo' => [
        'showLogo' => true,
        'logoWidth' => 80,
    ],
    'banner' => [
        'backgroundColor' => '#ffff',
        'height',
    ],
    'introduction' => [
        'introductionFieldName' => 'introduction',
    ],
    'sections' => [
        'news'       => [
            'sectionTitleStrKey' => 'newsletter.news_title',
            'types' => ['news'],
            'dateFormat' => '%d/%m/%Y',
            'showCategoryTitle' => true,
            'showIntroduction' => true,
            'defaultCategoryColor' => '#B32027',
            'link' => [
                'sectionLinkUrl'  => 'actualites',
                'sectionTextColor' => '#203169',
            ],
        ],
        'events'     => [
            'sectionTitleStrKey' => 'newsletter.events_title',
            'types' => ['events'],
            'sorts' => ['date:desc'],
            'dateFormat' => '%d/%m/%Y',
            'categoryFieldName' => 'events_categories',
            'defaultCategoryColor' => '#B32027',
            'link' => [
                'sectionLinkUrl'   => 'events',
                'sectionTextColor' => '#203169',
            ],
        ],
        'documents'  => [
            'sectionTitleStrKey' => 'newsletter.documents_title',
            'types'           => ['documents'],
            'sorts' => ['created_at:desc'],
            'imageStyle' => 'medium',
            'dateFormat' => '%d/%m/%Y',
            'link'            => [
                'sectionLinkStrKey' => 'newsletter.see_all_documents',
                'sectionLinkUrl' => 'bibliotheque',
                'sectionTextColor' => '#203169'
            ],
        ],
    ],
    'socials'      => [
        'backgroundColor' => '#000555',
        'links' => [
            'linkedin' => [
                'url' => 'https://fr.linkedin.com/company/nausicaa-centre-national-de-la-mer',
            ],
            'facebook' => [
                'url' => 'https://www.facebook.com/NausicaaCNM/?locale=fr_FR',
            ],
            'instagram' => [
                'url' => 'https://www.instagram.com/planetenausicaa/?hl=fr',
            ],
            'tiktok' => [
                'url' => 'https://www.tiktok.com/@nausicaa_officiel',
            ],
            'youtube' => [
                'url' => 'https://www.youtube.com/user/nausicaaboulogne',
            ]
        ],
    ],
];
