<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class MakeToolsCategoriesListingsRequired extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            type: 'tools_categories',
            fieldName: 'tools_categories_listings',
            options: [
                'required' => true,
                'title' => [
                    'fr' => 'Listing catégorie d\'outils',
                    'en' => 'Tools categories listing',
                    'es' => 'Listado de categorías de herramientas',
                    'pt' => 'Listagem de categorias de ferramentas',
                    'de' => 'Werkzeugkategorienliste',
                    'nl' => 'Lijst van gereedschapscategorieën',
                ],
            ],
        );
    }
}
