<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class MakeTabsSpacesRequired extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            type: 'tabs',
            fieldName: 'tabs_spaces',
            options: [
                'required' => true,
                'title' => [
                    'fr' => 'Espace à onglets',
                    'en' => 'Tabbed space',
                    'nl' => 'Ruimte met tabbladen',
                    'pt' => 'Espaço com guias',
                    'es' => 'Espacio con pestañas',
                    'de' => 'Leerzeichen mit Tabs',
                ],
            ],
        );
    }
}
