<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Users;
use Inside\Notify\Models\NotificationSubscriber;
use Inside\Notify\Models\NotificationType;
use Inside\Notify\Models\NotificationTypeRole;
use Inside\Permission\Models\Role;

class NausAddNotifications extends Migration
{
    public function up(): void
    {
        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via' => 'web',
                'default' => true,
                'event' => 'Inside\Content\Events\ContentCreatedEvent',
                'model' => 'Inside\Content\Models\Contents\Comments',
                'action' => 'contentCommented',
                'type' => 'global',
                'condition' => 'parent_type:news,events|author:CURRENT_USER',
                'multiple' => true,
                'profile' => true,
                'data' => [
                    'title' => 'notifications.create.comment.content.title',
                    'description' => 'notifications.create.comment.content.description',
                    'icon' => 'comment',
                    'text' => 'notifications.create.comment.content.<content_type>.text',
                    'fields' => [
                        'title',
                        'content_type',
                        'notification-data.from' => ['firstname', 'lastname']
                    ],
                ]
            ]
        );

        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via' => 'email',
                'default' => true,
                'event' => 'Inside\Content\Events\ContentCreatedEvent',
                'model' => 'Inside\Content\Models\Contents\Comments',
                'action' => 'contentCommented',
                'type' => 'global',
                'condition' => 'parent_type:news,events|author:CURRENT_USER',
                'multiple' => true,
                'profile' => true,
                'data' => [
                    'title' => 'notifications.create.comment.content.title',
                    'description' => 'notifications.create.comment.content.description',
                    'icon' => 'comment',
                    'mail' => [
                        'subject' => 'notifications.create.comment.content.mail.subject',
                        'text' => 'notifications.create.comment.content.mail.<content_type>.text',
                        'buttonText' => 'notifications.create.comment.content.mail.buttonText',
                    ],
                    'fields' => [
                        'title',
                        'content_type',
                        'notification-data.from' => ['firstname', 'lastname']
                    ],
                ]
            ]
        );

        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via' => 'web',
                'default' => true,
                'event' => 'Inside\Content\Events\CommentCreatedEvent',
                'model' => 'Inside\Content\Models\Contents\Comments',
                'action' => 'commentCommented',
                'type' => 'global',
                'condition' => 'author:CURRENT_USER',
                'multiple' => true,
                'profile' => true,
                'language' => false,
                'data' => [
                    'title' => 'notifications.create.comment.comment.title',
                    'description' => 'notifications.create.comment.comment.description',
                    'icon' => 'comment',
                    'text' => 'notifications.create.comment.comment.<content_type>.text',
                    'fields' => [
                        'notification-data.from' => ['firstname', 'lastname'],
                        'title',
                        'content_type'
                    ],
                ],
            ]
        );

        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via' => 'email',
                'default' => true,
                'event' => 'Inside\Content\Events\CommentCreatedEvent',
                'model' => 'Inside\Content\Models\Contents\Comments',
                'action' => 'commentCommented',
                'type' => 'global',
                'condition' => 'author:CURRENT_USER',
                'multiple' => true,
                'profile' => true,
                'language' => false,
                'data' => [
                    'title' => 'notifications.create.comment.comment.title',
                    'description' => 'notifications.create.comment.comment.description',
                    'icon' => 'comment',
                    'mail' => [
                        'subject' => 'notifications.create.comment.comment.mail.subject',
                        'text' => 'notifications.create.comment.comment.mail.text',
                        'buttonText' => 'notifications.create.comment.comment.mail.buttonText',
                    ],
                    'fields' => [
                        'notification-data.from' => ['firstname', 'lastname'],
                        'title',
                        'content_type'
                    ],
                ],
            ]
        );

        foreach ($notificationTypes as $notificationType) {
            Users::all()->each(
                function ($user) use ($notificationType) {
                    NotificationSubscriber::firstOrCreate(
                        [
                            'user_uuid' => $user->uuid,
                            'notification_type_id' => $notificationType->id,
                        ]
                    );
                }
            );
        }
    }
}
