import AdminAdvancedSettingsHomePage from '../pages/advanced-settings/AdminAdvancedSettingsHomePage'
import AdminAdvancedSettingsIdentityPage from '../pages/advanced-settings/AdminAdvancedSettingsIdentityPage'
import { fetchSettings } from '@inside-administration/fetch'

import { withFetch } from 'inside-collection/hocs'

export default [
  {
    name: 'HomePage',
    component: () => import('../pages/HomePage'),
    meta: { disabled: false }
  },
  {
    name: 'GedPage',
    path: '/guide-juridique-rh',
    component: () => import('../pages/ged/GedPage'),
    meta: { disabled: false }
  },
  {
    name: 'FAQListingPage',
    path: '/questions-frequentes',
    component: () => import('../pages/faq/FAQListingPage')
  },
  {
    name: 'FAQPage',
    path: '/questions-frequentes/:slug',
    component: () => import('../pages/faq/FAQPage')
  },
  {
    name: 'FlashListingPage',
    path: '/flash-social',
    component: () => import('../pages/flash/FlashListingPage')
  },
  {
    name: 'FlashPage',
    path: '/flash-social/:slug',
    component: () => import('../pages/flash/FlashPage')
  },
  {
    name: 'SimplePage',
    meta: { disabled: false }
  },
  {
    name: 'AdminAdvancedSettingsHomePage',
    component: withFetch(AdminAdvancedSettingsHomePage, { size: 'xxl' })(
      fetchSettings
    ),
    meta: { admin: true, display: true }
  },
  {
    name: 'AdminAdvancedSettingsIdentityPage',
    component: withFetch(AdminAdvancedSettingsIdentityPage, { size: 'xxl' })(
      fetchSettings
    ),
    meta: { admin: true, display: true }
  },
  {
    name: 'AdminDeveloperToolsAuditPage',
    meta: {
      permissionKey: 'system', disabled: true
    }
  }
]
