export default {
  globals: {
    icons: {
      bookmark: 'rate',
      bookmarkFill: 'rate-fill'
    }
  },
  'inside-administration': {
    disabledAdvancedSettingsFields: [
      'news_enable_likes',
      'news_enable_comments'
    ]
  },
  'inside-archives': {
    isEnabled: true
  },
  'inside-edition': {
    duplicateEnabled: true
  },
  'inside-ged': {
    useV2: true,
    paragraphs: {
      fetchedContents: {
        display: () => import('./components/commons/DocumentCard'),
        requestFields: [
          'uuid',
          'content_type',
          'file',
          'has_section',
          'title',
          'uri'
        ]
      }
    }
  },
  'inside-layouts': {
    linkMobileMenuEnabled: [
      { name: 'home', icon: 'house', link: { name: 'HomePage' } },
      { name: 'menu' },
      { name: 'search', icon: 'lens', link: { name: 'GlobalSearchPage' } },
      {
        name: 'profile',
        icon: 'avatar',
        link: { name: 'ProfileMenuMobilePage' }
      }
    ]
  },
  'inside-paragraphs': {
    fetchedContents: {
      availabledContentTypes: ['users', 'legal_documents'],
      configCorrespondance: {
        legal_documents: 'inside-ged'
      }
    }
  },
  'inside-users': {
    login: {
      useGradient: false,
      useImage: true,
      useBackgroundImage: true
    },
    profil: {
      enabledProfilTabs: [{ name: 'bookmarks', restrictions: [], icon: 'rate' }]
    }
  }
}
