import { http } from '@inside-library/helpers/Http'

export default {
  legalDocuments: {
    add: async ({ data }) => {
      const { data: docData } = await http.get('content/legal_documents', {
        fields: ['uuid', { folders: ['uuid'] }],
        filters: { 'uuid:eq': data.uuid }
      })

      return {
        name: 'GedPage',
        query: { folder: docData[0].folders.data[0].uuid }
      }
    },
    delete: async ({ uuid }) => {
      const { data: docData } = await http.get('content/legal_documents', {
        fields: ['uuid', { folders: ['uuid'] }],
        filters: { 'uuid:eq': uuid }
      })

      return {
        name: 'GedPage',
        query: { folder: docData[0].folders.data[0].uuid }
      }
    },
    globalSearch: ({ data }) => {
      return {
        route: {
          name: 'FAQPage',
          params: { slug: data.slug[0] }
        }
      }
    }
  },
  faqs: {
    add: () => ({
      name: 'FAQListingPage'
    }),
    delete: () => ({
      name: 'FAQListingPage'
    }),
    globalSearch: async ({ vm, data }) => {
      const { data: faqData } = await http.get('content/faqs', {
        fields: [{ legal_documents: ['slug'] }],
        filters: { 'uuid:eq': data.uuid }
      })

      return {
        route: {
          name: 'FAQPage',
          params: { slug: faqData[0].legal_documents.slug[0] }
        }
      }
    }
  },
  flashes: {
    add: async ({ data }) => {
      const { data: flashData } = await http.get('content/flashes', {
        fields: ['uuid', 'slug'],
        filters: { 'uuid:eq': data.uuid }
      })

      return {
        name: 'FlashPage',
        params: { slug: flashData[0].slug[0] }
      }
    },
    delete: () => ({
      name: 'FlashListingPage'
    })
  }
}
