<?php

namespace Inside\MSLH\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Inside\Content\Events\ContentFullyUpdatedEvent;
use Inside\Content\Models\Contents\Faqs;
use Inside\Content\Models\Contents\LegalDocuments;
use Inside\MSLH\Facades\PermissionCustom;
use Inside\Permission\Facades\PermissionSchema;
use Inside\Permission\Facades\Role as RoleService;
use Inside\Permission\Models\Role;

class UpdatedPermissionCustomFaqsListeners implements ShouldQueue
{
    /**
     * @param ContentFullyUpdatedEvent $event
     * @throws \Exception
     */
    public function handle(ContentFullyUpdatedEvent $event): void
    {
        if (in_array($event->model->content_type, ['legal_documents'])) {
            $faqs = Faqs::whereHas('legalDocuments', function ($query) use ($event) {
                $query->where('inside_content_legal_documents.uuid', $event->model->uuid);
            });
            $permissions = $this->checkPermission($event->model->uuid);

            foreach ($faqs->get() as $faq) {
                PermissionSchema::resetContentSpecificPermissions($faq->uuid, class_to_type($faq));
                PermissionCustom::setPermissions($faq->uuid, $permissions['authorize'], $permissions['revoke']);
            }
        } elseif (in_array($event->model->content_type, ['faqs'])) {
            $permissions = $this->checkPermission($event->model->LegalDocuments[0]->uuid);

            PermissionSchema::resetContentSpecificPermissions($event->model->uuid, class_to_type($event->model));
            PermissionCustom::setPermissions($event->model->uuid, $permissions['authorize'], $permissions['revoke']);
        }
    }

    /**
     * @param string $uuid
     *
     * @return array[]
     */
    protected function checkPermission(string $uuid): array
    {
        $roles = Role::all();
        $legalDocuments = LegalDocuments::find($uuid);
        $roleAuthorize = [
            'revoke' => [],
            'authorize' => []
        ];
        foreach ($roles as $role) {
            if (RoleService::can('read', $legalDocuments, $role->id)) {
                array_push($roleAuthorize['authorize'], $role->id);
            } else {
                array_push($roleAuthorize['revoke'], $role->id);
            }
        }

        return $roleAuthorize;
    }
}
