<?php

namespace Inside\MSLH\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Inside\Content\Events\ContentFullyInsertedEvent;
use Inside\Content\Models\Contents\LegalDocuments;
use Inside\MSLH\Facades\PermissionCustom;
use Inside\Permission\Facades\Role as RoleService;
use Inside\Permission\Models\Role;

class CreatedPermissionCustomFaqsListeners implements ShouldQueue
{
    /**
     * @param ContentFullyInsertedEvent $event
     * @throws \Exception
     */
    public function handle(ContentFullyInsertedEvent $event): void
    {
        if (!in_array($event->model->content_type, ['faqs'])) {
            return;
        }

        $data = [];
        $roles = Role::all();
        $legalDocuments = LegalDocuments::find($event->model->LegalDocuments[0]->uuid);
        foreach ($roles as $role) {
            if (RoleService::can('read', $legalDocuments, $role->id)) {
                $data[] = $role->id;
            }
        }

        PermissionCustom::setPermissions($event->model->uuid, $data);
    }
}
