<?php

namespace Inside\MSLH\Providers;

use Inside\Content\Events\ContentFullyInsertedEvent;
use Inside\Content\Events\ContentFullyUpdatedEvent;
use Inside\MSLH\Listeners\CreatedPermissionCustomFaqsListeners;
use Inside\MSLH\Listeners\UpdatedPermissionCustomFaqsListeners;
use Inside\Support\EventServiceProvider as BaseServiceProvider;
use Psr\Container\ContainerExceptionInterface;
use Psr\Container\NotFoundExceptionInterface;

/**
 * MSLH Service provider.
 *
 * @category Class
 * @package  Inside\MSLH\Providers\ServiceProvider
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class ServiceProvider extends BaseServiceProvider
{
    protected array $listen = [
        ContentFullyInsertedEvent::class => [
            CreatedPermissionCustomFaqsListeners::class,
        ],
        ContentFullyUpdatedEvent::class => [
            UpdatedPermissionCustomFaqsListeners::class,
        ],
    ];

    public function register(): void
    {
        try {
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/scheduler.php', 'scheduler');
            $this->mergeConfigTo(__DIR__.'/../../config/lhg_import.php', 'lhg_import');
            $this->mergeConfigTo(__DIR__.'/../../config/louvrehotels.php', 'louvrehotels');
            $this->mergeConfigTo(__DIR__.'/../../config/duplication.php', 'duplication');
        } catch (NotFoundExceptionInterface|ContainerExceptionInterface) {
        }
    }
}
