<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\DB;
use Inside\Host\Bridge\BridgeContent;
use Inside\Layout\Models\LayoutPath;
use Inside\Layout\Models\Layout;

class SeedCustomPages extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContent();

        collect([
            ['title' => 'Questions fréquentes', 'custom_slug' => 'faq-listing', 'redirection_page' => 'FAQListingPage'],
            ['title' => 'Flash social', 'custom_slug' => 'flash-listing', 'redirection_page' => 'FlashListingPage'],
            ['title' => 'Guide Juridique RH', 'custom_slug' => 'ged', 'redirection_page' => 'GedPage'],
        ])
            ->map(
                fn ($custom) => Arr::add($custom, 'uuid', DB::table('inside_content_custom')->where('title', $custom['title'])->first()?->uuid)
            )
            ->each(fn ($custom) => $bridge->contentUpdate(type: 'custom', data: $custom, fromCli: true));

        LayoutPath::with('layout')
            ->where('path', 'not like', 'inside_content_forms.%')
            ->get()
            ->pluck('layout')
            ->each(fn (Layout $layout) => $layout->delete());
    }
}
