<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Notify\Models\NotificationType;
use Illuminate\Support\Facades\Schema;

class deleteTypeAndNotifsOfFormType extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeDelete('forms');

        $tables = [
            'inside_forms_answers_logs',
            'inside_forms_answers',
            'inside_forms_submissions'
        ];

        foreach ($tables as $table) {
            Schema::drop($table);
        }

        NotificationType::query()->where('model', 'Inside\Form\Models\FormSubmission')->delete();

        $migrations = [
            '2018_11_29_000000_create_forms_answers_table',
            '2018_11_29_000001_remove_field_type_to_answers_table',
            '2018_12_13_000000_create_forms_answers_logs_table',
            '2018_12_27_000000_drop_forms_answers_logs_table',
            '2018_12_27_000001_drop_forms_answers_table',
            '2018_12_27_000002_create_forms_submissions_table',
            '2018_12_27_000003_refactor_forms_answers_table',
            '2018_12_27_000004_refactor_forms_answers_logs_table',
            '2019_01_03_000000_add_notify_field_to_forms_submissions_table',
            '2019_01_16_000000_add_status_field_to_forms_submissions_table',
            '2019_01_17_000000_add_default_value_to_status_field_in_forms_submissions_table',
            '2019_07_25_000000_change_status_type_field_in_forms_submissions_table',
            '2019_10_01_000000_update_form_to_v2',
            '2020_01_24_000000_ehance_forms_mail_notifications',
            '2020_06_03_000000_add_status_notifications',
            '2020_06_22_000000_add_introduction_to_form',
            '2020_07_28_000000_change_forms_answers_answer_to_nullable',
            '2020_10_14_000000_change_status_notifications_to_system',
            '2021_04_13_000000_improve_forms',
            '2021_04_21_000000_delete_old_introduction_field_in_forms',
            '2021_07_08_000000_recreate_admin_roles_field_if_needed',
            '2021_08_16_000000_add_submission_web_notification',
            '2021_08_23_000000_add_status_notifications_email',
        ];

        DB::table('migrations')->whereIn('migration', $migrations)->delete();
    }
}
