<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class FixLegalDocumentsCardinality extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeDeleteField('node', 'faqs', 'legal_documents');
        $bridge->contentTypeCreateOrUpdateField(
            'faqs',
            'legal_documents',
            [
                'name' => 'legal_documents',
                'searchable' => true,
                'translatable' => false,
                'default' => null,
                'search_result_field' => false,
                'required' => true,
                'weight' => 1,
                'title' => [
                    'fr' => 'Fiche juridique',
                ],
                'description' => [
                    'fr' => '',
                ],
                'widget' => [
                    'type' => BridgeContentType::AUTOCOMPLETE_WIDGET,
                    'settings' => [],
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['legal_documents'],
                    'cardinality' => 1,
                ],
            ],
            1
        );
    }

    public function down(): void
    {
    }
}
