<?php

use Inside\Host\Bridge\BridgeContentType;

$weight = 1;

return [
    'options' => [
        'name' => 'legal_documents',
        'listing_type' => 'content',
        'translatable' => false,
        'searchable' => true,
        'global_searchable' => true,
        'aliasable' => false,
        'permissible' => true,
        'categorizable' => false,
        'title' => [
          'fr' => 'Fiche juridique',
        ],
    ],
    'fields' => [
        [
          'name' => 'chapo',
          'searchable' => true,
          'translatable' => false,
          'default' => null,
          'search_result_field' => false,
          'required' => false,
          'weight' => $weight,
          'title' => [
            'fr' => 'Chapô'
          ],
          'description' => [
            'fr' => 'Je suis une description de chapo !'
          ],
          'widget' => [
            'type' => BridgeContentType::LONGTEXT_WIDGET,
            'settings' => [
              'rows' => 5,
              'placeholder' => '',
            ],
            'weight' => $weight++,
          ],
          'type' => BridgeContentType::TEXTAREA_FIELD,
          'settings' => [
            'case_sensitive' => false,
            'cardinality' => 1,
          ],
        ],
        [
            'name' => 'content',
            'searchable' => true,
            'translatable' => false,
            'default' => null,
            'search_result_field' => true,
            'required' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Contenu',
            ],
            'description' => [],
            'widget' => [
                'type' => BridgeContentType::SECTION_WIDGET,
                'settings' => [
                    'title' => 'Paragraph',
                    'title_plural' => 'Paragraphs',
                    'edit_mode' => 'closed',
                    'add_mode' => 'dropdown',
                    'form_display_mode' => 'default',
                    'default_paragraph_type' => '_none',
                ],
                'weight' => $weight++,
            ],
            'type' => BridgeContentType::SECTION_FIELD,
            'settings' => [
                'target_type' => [
                    'text',
                    'text_with_image',
                    'image',
                    'file',
                    'slider',
                    'video',
                    'html',
                ],
                'cardinality' => -1,
            ],
        ],
        [
            'name' => 'folders',
            'searchable' => false,
            'translatable' => false,
            'default' => null,
            'search_result_field' => false,
            'required' => true,
            'weight' => $weight,
            'title' => [
                'fr' => 'Dossier parent',
            ],
            'description' => [],
            'widget' => [
                'type' => BridgeContentType::AUTOCOMPLETE_WIDGET,
                'settings' => [],
                'weight' => $weight++,
                'group' => 'group_advanced_options',
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['folders'],
                'cardinality' => -1,
            ],
        ],
    ],
];
