<?php

use Inside\Host\Bridge\BridgeContentType;

$weight = 1;

return [
    'options' => [
        'name' => 'folders',
        'listing_type' => 'taxo',
        'translatable' => false,
        'searchable' => true,
        'global_searchable' => true,
        'aliasable' => false,
        'permissible' => true,
        'categorizable' => true,
        'title' => [
            'fr' => 'Dossiers',
        ],
    ],
    'fields' => [
        [
            'name' => 'folders',
            'searchable' => false,
            'translatable' => false,
            'default' => null,
            'search_result_field' => false,
            'required' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Dossier parent',
            ],
            'description' => [
                'fr' => '',
            ],
            'widget' => [
                'type' => BridgeContentType::AUTOCOMPLETE_WIDGET,
                'settings' => [],
                'weight' => $weight++,
                'group' => 'group_advanced_options',
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['folders'],
                'cardinality' => -1,
            ],
        ],
        [
            'name' => 'image',
            'searchable' => false,
            'translatable' => false,
            'default' => null,
            'search_result_field' => false,
            'required' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Image',
            ],
            'description' => [
                'fr' => '',
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => $weight++,
                'group' => 'group_advanced_options',
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ]
        ],
      [
        'name' => 'color',
        'searchable' => true,
        'translatable' => false,
        'default' => null,
        'search_result_field' => true,
        'required' => false,
        'weight' => $weight,
        'title' => [
          'fr' => 'Couleur'
        ],
        'description' => [],
        'widget' => [
          'type' => BridgeContentType::STRING_WIDGET,
          'settings' => [
            'size' => 60,
            'placeholder' => '',
          ],
          'weight' => $weight++,
          'group' => 'group_advanced_options',
        ],
        'type' => BridgeContentType::TEXT_FIELD,
        'settings' => [
          'max_length' => 255,
          'is_ascii' => false,
          'case_sensitive' => false,
          'cardinality' => 1,
        ],
      ]
    ]
];
